// Font size 4

#include "Font32.h"
#include <avr/pgmspace.h>


PROGMEM const unsigned char widtbl_f32[96] =         // character width table
{
        8, 11, 11, 22, 17, 24, 20, 9,       // char 32 - 39
        11, 11, 15, 13, 10, 11, 10, 11,     // char 40 - 47
        17, 17, 17, 17, 17, 17, 17, 17,     // char 48 - 55
        17, 17, 10, 10, 17, 12, 17, 16,     // char 56 - 63
        28, 19, 20, 21, 21, 19, 18, 22,     // char 64 - 71
        21, 9, 16, 20, 16, 24, 21, 22,      // char 72 - 79
        19, 22, 20, 19, 17, 21, 18, 26,     // char 80 - 87
        18, 19, 19, 12, 16, 12, 15, 16,     // char 88 - 95
        12, 17, 18, 16, 18, 17, 11, 18,     // char 96 - 103
        18, 9, 9, 15, 9, 25, 18, 18,        // char 104 - 111
        18, 18, 11, 15, 10, 17, 15, 21,     // char 112 - 119
        16, 16, 15, 16, 16, 16, 18, 4       // char 120 - 127
};

// Row format, MSB left

PROGMEM const unsigned char chr_f32_20[] =         // 1 byte per row
{
        0x00, 0x00, 0x00, 0x00, 0x00,    // row 1 - 11
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 12 - 22
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00           // row 23 - 32
};
PROGMEM const unsigned char chr_f32_21[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 7 - 12
        0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 13 - 18
        0x18, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 19 - 24
        0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_22[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x24, 0x00, 0x24, 0x00, 0x24, 0x00, 0x24, 0x00, 0x24, 0x00,    // row 7 - 12
        0x24, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 13 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_23[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x66, 0x00, 0x00, 0x44, 0x00, 0x00, 0x44, 0x00, 0x00, 0xCC, 0x00,    // row 9 - 12
        0x00, 0x88, 0x00, 0x00, 0x88, 0x00, 0x1F, 0xFF, 0x80, 0x01, 0x10, 0x00,    // row 13 - 16
        0x01, 0x10, 0x00, 0x01, 0x10, 0x00, 0x3F, 0xFF, 0x00, 0x02, 0x20, 0x00,    // row 17 - 20
        0x02, 0x20, 0x00, 0x06, 0x60, 0x00, 0x04, 0x40, 0x00, 0x04, 0x40, 0x00,    // row 21 - 24
        0x0C, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_24[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x0F, 0xC0, 0x00, 0x3F, 0xF0, 0x00, 0x38, 0x70, 0x00, 0x60, 0x18, 0x00,    // row 9 - 12
        0x60, 0x18, 0x00, 0x60, 0x00, 0x00, 0x70, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 13 - 16
        0x7F, 0x80, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00,    // row 17 - 20
        0x18, 0x00, 0x00, 0x30, 0x00, 0x00, 0x3F, 0x88, 0x00, 0x7F, 0xF8, 0x00,    // row 21 - 24
        0x60, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_25[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x0E, 0x01, 0x80, 0x3F, 0x81, 0x00, 0x31, 0x83, 0x00, 0x60, 0xC6, 0x00,    // row 9 - 12
        0x60, 0xC4, 0x00, 0x60, 0xCC, 0x00, 0x31, 0x88, 0x00, 0x3F, 0x90, 0x00,    // row 13 - 16
        0x0E, 0x31, 0xC0, 0x00, 0x27, 0xF0, 0x00, 0x46, 0x30, 0x00, 0xCC, 0x18,    // row 17 - 20
        0x00, 0x8C, 0x18, 0x01, 0x8C, 0x18, 0x03, 0x06, 0x30, 0x02, 0x07, 0xF0,    // row 21 - 24
        0x06, 0x01, 0xC0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_26[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x07, 0xC0, 0x00,    // row 5 - 8
        0x0F, 0xE0, 0x00, 0x1C, 0x70, 0x00, 0x18, 0x30, 0x00, 0x18, 0x30, 0x00,    // row 9 - 12
        0x18, 0x70, 0x00, 0x0C, 0xE0, 0x00, 0x07, 0xC0, 0x00, 0x0F, 0x00, 0x00,    // row 13 - 16
        0x1F, 0x86, 0x00, 0x39, 0xC6, 0x00, 0x70, 0xE6, 0x00, 0x60, 0x7C, 0x00,    // row 17 - 20
        0x60, 0x3C, 0x00, 0x60, 0x18, 0x00, 0x70, 0x7E, 0x00, 0x3F, 0xE7, 0x00,    // row 21 - 24
        0x1F, 0x83, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_27[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x10, 0x00, 0x30, 0x00,    // row 7 - 12
        0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 13 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_28[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x03, 0x00, 0x02, 0x00, 0x06, 0x00, 0x04, 0x00, 0x0C, 0x00,    // row 7 - 12
        0x0C, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 13 - 18
        0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 19 - 24
        0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x06, 0x00, 0x02, 0x00,    // row 25 - 30
        0x03, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_29[] =         // 2 bytes per row
{
        0x00, 0x00, 0xC0, 0x00, 0x40, 0x00, 0x60, 0x00, 0x20, 0x00, 0x30, 0x00,    // row 7 - 12
        0x30, 0x00, 0x30, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 13 - 18
        0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 19 - 24
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x60, 0x00, 0x40, 0x00,    // row 25 - 30
        0xC0, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_2A[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x26, 0x40, 0x7F, 0xE0,    // row 7 - 12
        0x1F, 0x80, 0x0F, 0x00, 0x19, 0x80, 0x39, 0xC0, 0x10, 0x80, 0x00, 0x00,    // row 13 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_2B[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x7F, 0x80,    // row 13 - 18
        0x7F, 0x80, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_2C[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 13 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,    // row 19 - 24
        0x38, 0x00, 0x08, 0x00, 0x18, 0x00, 0x10, 0x00, 0x30, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_2D[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00,    // row 13 - 18
        0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_2E[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 13 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,    // row 19 - 24
        0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_2F[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x02, 0x00, 0x06, 0x00, 0x06, 0x00,    // row 7 - 12
        0x04, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x08, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 13 - 18
        0x10, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x60, 0x00, 0x60, 0x00,    // row 19 - 24
        0x40, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_30[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x07, 0x80, 0x00, 0x1F, 0xE0, 0x00, 0x3C, 0xF0, 0x00, 0x30, 0x30, 0x00,    // row 9 - 12
        0x70, 0x38, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00,    // row 13 - 16
        0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00,    // row 17 - 20
        0x70, 0x38, 0x00, 0x30, 0x30, 0x00, 0x3C, 0xF0, 0x00, 0x1F, 0xE0, 0x00,    // row 21 - 24
        0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_31[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x01, 0x80, 0x00, 0x01, 0x80, 0x00, 0x03, 0x80, 0x00, 0x1F, 0x80, 0x00,    // row 9 - 12
        0x1F, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00,    // row 13 - 16
        0x01, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00,    // row 17 - 20
        0x01, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00,    // row 21 - 24
        0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_32[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x0F, 0xC0, 0x00, 0x3F, 0xF0, 0x00, 0x38, 0x70, 0x00, 0x70, 0x18, 0x00,    // row 9 - 12
        0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x38, 0x00,    // row 13 - 16
        0x00, 0xF0, 0x00, 0x03, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x1E, 0x00, 0x00,    // row 17 - 20
        0x38, 0x00, 0x00, 0x70, 0x00, 0x00, 0x60, 0x00, 0x00, 0x7F, 0xF8, 0x00,    // row 21 - 24
        0x7F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_33[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x0F, 0xC0, 0x00, 0x1F, 0xE0, 0x00, 0x38, 0x70, 0x00, 0x30, 0x30, 0x00,    // row 9 - 12
        0x70, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x70, 0x00, 0x03, 0xE0, 0x00,    // row 13 - 16
        0x03, 0xF0, 0x00, 0x00, 0x38, 0x00, 0x00, 0x18, 0x00, 0x60, 0x18, 0x00,    // row 17 - 20
        0x60, 0x18, 0x00, 0x70, 0x38, 0x00, 0x38, 0x70, 0x00, 0x3F, 0xF0, 0x00,    // row 21 - 24
        0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_34[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x60, 0x00, 0x00, 0xE0, 0x00, 0x01, 0xE0, 0x00, 0x01, 0xE0, 0x00,    // row 9 - 12
        0x03, 0x60, 0x00, 0x06, 0x60, 0x00, 0x0C, 0x60, 0x00, 0x0C, 0x60, 0x00,    // row 13 - 16
        0x18, 0x60, 0x00, 0x30, 0x60, 0x00, 0x60, 0x60, 0x00, 0x7F, 0xF8, 0x00,    // row 17 - 20
        0x7F, 0xF8, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00,    // row 21 - 24
        0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_35[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x3F, 0xF0, 0x00, 0x3F, 0xF0, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 9 - 12
        0x30, 0x00, 0x00, 0x37, 0xC0, 0x00, 0x3F, 0xF0, 0x00, 0x78, 0x70, 0x00,    // row 13 - 16
        0x60, 0x38, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00,    // row 17 - 20
        0x60, 0x18, 0x00, 0x70, 0x38, 0x00, 0x38, 0x70, 0x00, 0x3F, 0xF0, 0x00,    // row 21 - 24
        0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_36[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x07, 0xC0, 0x00, 0x1F, 0xF0, 0x00, 0x38, 0x30, 0x00, 0x30, 0x18, 0x00,    // row 9 - 12
        0x30, 0x18, 0x00, 0x60, 0x00, 0x00, 0x67, 0xC0, 0x00, 0x7F, 0xF0, 0x00,    // row 13 - 16
        0x78, 0x70, 0x00, 0x70, 0x38, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00,    // row 17 - 20
        0x60, 0x18, 0x00, 0x30, 0x38, 0x00, 0x38, 0x70, 0x00, 0x1F, 0xF0, 0x00,    // row 21 - 24
        0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_37[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x7F, 0xF8, 0x00, 0x7F, 0xF8, 0x00, 0x00, 0x30, 0x00, 0x00, 0x70, 0x00,    // row 9 - 12
        0x00, 0xE0, 0x00, 0x00, 0xC0, 0x00, 0x01, 0xC0, 0x00, 0x01, 0x80, 0x00,    // row 13 - 16
        0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00,    // row 17 - 20
        0x06, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x00, 0x00,    // row 21 - 24
        0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_38[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x07, 0x80, 0x00, 0x1F, 0xE0, 0x00, 0x18, 0x60, 0x00, 0x30, 0x30, 0x00,    // row 9 - 12
        0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x18, 0x60, 0x00, 0x0F, 0xC0, 0x00,    // row 13 - 16
        0x1F, 0xE0, 0x00, 0x38, 0x70, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00,    // row 17 - 20
        0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x38, 0x70, 0x00, 0x3F, 0xF0, 0x00,    // row 21 - 24
        0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_39[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x0F, 0xC0, 0x00, 0x3F, 0xE0, 0x00, 0x38, 0x70, 0x00, 0x70, 0x30, 0x00,    // row 9 - 12
        0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x70, 0x38, 0x00,    // row 13 - 16
        0x38, 0x78, 0x00, 0x3F, 0xF8, 0x00, 0x0F, 0x98, 0x00, 0x00, 0x18, 0x00,    // row 17 - 20
        0x60, 0x30, 0x00, 0x60, 0x30, 0x00, 0x30, 0x70, 0x00, 0x3F, 0xE0, 0x00,    // row 21 - 24
        0x1F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_3A[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 13 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,    // row 19 - 24
        0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_3B[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 13 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,    // row 19 - 24
        0x38, 0x00, 0x08, 0x00, 0x18, 0x00, 0x10, 0x00, 0x30, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_3C[] =        // 3 bytes per row
{
           // row 1 - 3
           // row 4 - 6  I                 I
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 9
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 10 - 12
        0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0xE0, 0x00,    // row 13 - 15
        0x07, 0x80, 0x00, 0x1C, 0x00, 0x00, 0x60, 0x00, 0x00,    // row 16 - 18
        0x1C, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0xE0, 0x00,    // row 19 - 21
        0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 22 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 27
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 28 - 30
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00                             // row 31 - 32
};
PROGMEM const unsigned char chr_f32_3D[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x7F, 0x00, 0x00, 0x00,    // row 13 - 18
        0x00, 0x00, 0x7F, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_3E[] =        // 4 bytes per row
{
           // row 1 - 3
           // row 4 - 6        I                       I
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 9
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 10 - 12
        0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x1C, 0x00, 0x00,    // row 13 - 15
        0x07, 0x80, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x18, 0x00,    // row 16 - 18
        0x00, 0xE0, 0x00, 0x07, 0x80, 0x00, 0x1C, 0x00, 0x00,    // row 19 - 21
        0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 22 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 27
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 28 - 30
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00                             // row 31 - 32
};
PROGMEM const unsigned char chr_f32_3F[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x0F, 0xC0, 0x3F, 0xE0, 0x38, 0x70, 0x70, 0x30, 0x60, 0x30,    // row 7 - 12
        0x60, 0x30, 0x00, 0x70, 0x00, 0xE0, 0x01, 0xC0, 0x03, 0x80, 0x03, 0x00,    // row 13 - 18
        0x07, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x00,    // row 19 - 24
        0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_40[] =        // 4 bytes per row
{
           // row 1 - 3
           // row 4 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x01, 0xC0, 0x70, 0x00,    // row 7 - 9
        0x07, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x06, 0x00,    // row 10 - 12
        0x10, 0x1E, 0x43, 0x00, 0x30, 0x63, 0xC3, 0x00, 0x30, 0xC1, 0x83, 0x00,    // row 13 - 15
        0x60, 0xC1, 0x83, 0x00, 0x61, 0x81, 0x83, 0x00, 0x61, 0x81, 0x83, 0x00,    // row 16 - 18
        0x61, 0x83, 0x06, 0x00, 0x61, 0x83, 0x06, 0x00, 0x61, 0x83, 0x0C, 0x00,    // row 19 - 21
        0x30, 0xC7, 0x18, 0x00, 0x30, 0x79, 0xF0, 0x00, 0x18, 0x00, 0x00, 0x00,    // row 22 - 24
        0x0C, 0x00, 0x00, 0x00, 0x06, 0x00, 0x18, 0x00, 0x03, 0x81, 0xE0, 0x00,    // row 25 - 27
        0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 28 - 30
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00                             // row 31 - 32
};
PROGMEM const unsigned char chr_f32_41[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x03, 0xC0, 0x00,    // row 5 - 8
        0x03, 0xC0, 0x00, 0x03, 0xC0, 0x00, 0x06, 0x60, 0x00, 0x06, 0x60, 0x00,    // row 9 - 12
        0x06, 0x60, 0x00, 0x0C, 0x30, 0x00, 0x0C, 0x30, 0x00, 0x0C, 0x30, 0x00,    // row 13 - 16
        0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x1F, 0xF8, 0x00, 0x3F, 0xFC, 0x00,    // row 17 - 20
        0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00,    // row 21 - 24
        0xE0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_42[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00,    // row 5 - 8
        0x3F, 0xFE, 0x00, 0x30, 0x0E, 0x00, 0x30, 0x06, 0x00, 0x30, 0x06, 0x00,    // row 9 - 12
        0x30, 0x06, 0x00, 0x30, 0x06, 0x00, 0x30, 0x0E, 0x00, 0x3F, 0xF8, 0x00,    // row 13 - 16
        0x3F, 0xFE, 0x00, 0x30, 0x0E, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00,    // row 17 - 20
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x0E, 0x00, 0x3F, 0xFE, 0x00,    // row 21 - 24
        0x3F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_43[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x03, 0xF8, 0x00,    // row 5 - 8
        0x0F, 0xFE, 0x00, 0x1E, 0x0F, 0x00, 0x38, 0x03, 0x00, 0x30, 0x01, 0x80,    // row 9 - 12
        0x70, 0x01, 0x80, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00,    // row 13 - 16
        0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x01, 0x80, 0x70, 0x01, 0x80,    // row 17 - 20
        0x30, 0x03, 0x80, 0x38, 0x03, 0x00, 0x1E, 0x0F, 0x00, 0x0F, 0xFE, 0x00,    // row 21 - 24
        0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_44[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00,    // row 5 - 8
        0x3F, 0xFC, 0x00, 0x30, 0x1E, 0x00, 0x30, 0x07, 0x00, 0x30, 0x03, 0x00,    // row 9 - 12
        0x30, 0x03, 0x80, 0x30, 0x01, 0x80, 0x30, 0x01, 0x80, 0x30, 0x01, 0x80,    // row 13 - 16
        0x30, 0x01, 0x80, 0x30, 0x01, 0x80, 0x30, 0x01, 0x80, 0x30, 0x03, 0x80,    // row 17 - 20
        0x30, 0x03, 0x00, 0x30, 0x07, 0x00, 0x30, 0x1E, 0x00, 0x3F, 0xFC, 0x00,    // row 21 - 24
        0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_45[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x3F, 0xFE, 0x00,    // row 5 - 8
        0x3F, 0xFE, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 9 - 12
        0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x3F, 0xFC, 0x00,    // row 13 - 16
        0x3F, 0xFC, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 17 - 20
        0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x3F, 0xFE, 0x00,    // row 21 - 24
        0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_46[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00,    // row 5 - 8
        0x3F, 0xFC, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 9 - 12
        0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x3F, 0xF8, 0x00,    // row 13 - 16
        0x3F, 0xF8, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 17 - 20
        0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 21 - 24
        0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_47[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x03, 0xF8, 0x00,    // row 5 - 8
        0x0F, 0xFE, 0x00, 0x1C, 0x0F, 0x00, 0x38, 0x03, 0x00, 0x30, 0x03, 0x80,    // row 9 - 12
        0x70, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x7F, 0x80,    // row 13 - 16
        0x60, 0x7F, 0x80, 0x60, 0x01, 0x80, 0x60, 0x01, 0x80, 0x70, 0x01, 0x80,    // row 17 - 20
        0x30, 0x03, 0x80, 0x38, 0x07, 0x80, 0x1E, 0x0F, 0x80, 0x0F, 0xFD, 0x80,    // row 21 - 24
        0x03, 0xF0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_48[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x30, 0x03, 0x00,    // row 5 - 8
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00,    // row 9 - 12
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x3F, 0xFF, 0x00, 0x3F, 0xFF, 0x00,    // row 13 - 16
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00,    // row 17 - 20
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00,    // row 21 - 24
        0x30, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_49[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 7 - 12
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 13 - 18
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 19 - 24
        0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_4A[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60,    // row 7 - 12
        0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60,    // row 13 - 18
        0x00, 0x60, 0xC0, 0x60, 0xC0, 0x60, 0xC0, 0x60, 0xE0, 0xE0, 0x7F, 0xC0,    // row 19 - 24
        0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_4B[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x30, 0x07, 0x00,    // row 5 - 8
        0x30, 0x0E, 0x00, 0x30, 0x1C, 0x00, 0x30, 0x38, 0x00, 0x30, 0x70, 0x00,    // row 9 - 12
        0x30, 0xE0, 0x00, 0x31, 0xC0, 0x00, 0x33, 0x80, 0x00, 0x37, 0x80, 0x00,    // row 13 - 16
        0x3F, 0xC0, 0x00, 0x3C, 0xE0, 0x00, 0x38, 0x70, 0x00, 0x30, 0x30, 0x00,    // row 17 - 20
        0x30, 0x38, 0x00, 0x30, 0x1C, 0x00, 0x30, 0x0E, 0x00, 0x30, 0x07, 0x00,    // row 21 - 24
        0x30, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_4C[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 7 - 12
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 13 - 18
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x3F, 0xF8,    // row 19 - 24
        0x3F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_4D[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x38, 0x00, 0xE0,    // row 5 - 8
        0x3C, 0x01, 0xE0, 0x3C, 0x01, 0xE0, 0x3C, 0x01, 0xE0, 0x36, 0x03, 0x60,    // row 9 - 12
        0x36, 0x03, 0x60, 0x36, 0x03, 0x60, 0x33, 0x06, 0x60, 0x33, 0x06, 0x60,    // row 13 - 16
        0x33, 0x06, 0x60, 0x31, 0x8C, 0x60, 0x31, 0x8C, 0x60, 0x31, 0x8C, 0x60,    // row 17 - 20
        0x30, 0xD8, 0x60, 0x30, 0xD8, 0x60, 0x30, 0xF8, 0x60, 0x30, 0x70, 0x60,    // row 21 - 24
        0x30, 0x70, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_4E[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x38, 0x03, 0x00,    // row 5 - 8
        0x38, 0x03, 0x00, 0x3C, 0x03, 0x00, 0x3E, 0x03, 0x00, 0x36, 0x03, 0x00,    // row 9 - 12
        0x37, 0x03, 0x00, 0x33, 0x83, 0x00, 0x31, 0x83, 0x00, 0x31, 0xC3, 0x00,    // row 13 - 16
        0x30, 0xE3, 0x00, 0x30, 0x63, 0x00, 0x30, 0x73, 0x00, 0x30, 0x3B, 0x00,    // row 17 - 20
        0x30, 0x1B, 0x00, 0x30, 0x1F, 0x00, 0x30, 0x0F, 0x00, 0x30, 0x07, 0x00,    // row 21 - 24
        0x30, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_4F[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x03, 0xF8, 0x00,    // row 5 - 8
        0x0F, 0xFE, 0x00, 0x1E, 0x0F, 0x00, 0x38, 0x03, 0x80, 0x30, 0x01, 0x80,    // row 9 - 12
        0x70, 0x01, 0xC0, 0x60, 0x00, 0xC0, 0x60, 0x00, 0xC0, 0x60, 0x00, 0xC0,    // row 13 - 16
        0x60, 0x00, 0xC0, 0x60, 0x00, 0xC0, 0x60, 0x00, 0xC0, 0x70, 0x01, 0xC0,    // row 17 - 20
        0x30, 0x01, 0x80, 0x38, 0x03, 0x80, 0x1E, 0x0F, 0x00, 0x0F, 0xFE, 0x00,    // row 21 - 24
        0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_50[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00,    // row 5 - 8
        0x3F, 0xFC, 0x00, 0x30, 0x0E, 0x00, 0x30, 0x06, 0x00, 0x30, 0x06, 0x00,    // row 9 - 12
        0x30, 0x06, 0x00, 0x30, 0x06, 0x00, 0x30, 0x0E, 0x00, 0x3F, 0xFC, 0x00,    // row 13 - 16
        0x3F, 0xF8, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 17 - 20
        0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 21 - 24
        0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_51[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x03, 0xF8, 0x00,    // row 5 - 8
        0x0F, 0xFE, 0x00, 0x1E, 0x0F, 0x00, 0x38, 0x03, 0x80, 0x30, 0x01, 0x80,    // row 9 - 12
        0x70, 0x01, 0xC0, 0x60, 0x00, 0xC0, 0x60, 0x00, 0xC0, 0x60, 0x00, 0xC0,    // row 13 - 16
        0x60, 0x00, 0xC0, 0x60, 0x00, 0xC0, 0x60, 0x00, 0xC0, 0x70, 0x11, 0xC0,    // row 17 - 20
        0x30, 0x39, 0x80, 0x38, 0x1F, 0x80, 0x1E, 0x0F, 0x00, 0x0F, 0xFF, 0x80,    // row 21 - 24
        0x03, 0xF9, 0xC0, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_52[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00,    // row 5 - 8
        0x3F, 0xFE, 0x00, 0x30, 0x07, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00,    // row 9 - 12
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x06, 0x00, 0x3F, 0xFE, 0x00,    // row 13 - 16
        0x3F, 0xFC, 0x00, 0x30, 0x0E, 0x00, 0x30, 0x06, 0x00, 0x30, 0x07, 0x00,    // row 17 - 20
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00,    // row 21 - 24
        0x30, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_53[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x07, 0xE0, 0x00,    // row 5 - 8
        0x1F, 0xF8, 0x00, 0x38, 0x1C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00,    // row 9 - 12
        0x30, 0x0E, 0x00, 0x38, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x0F, 0xE0, 0x00,    // row 13 - 16
        0x01, 0xF8, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x0E, 0x00, 0x70, 0x06, 0x00,    // row 17 - 20
        0x30, 0x06, 0x00, 0x30, 0x06, 0x00, 0x3C, 0x0E, 0x00, 0x1F, 0xFC, 0x00,    // row 21 - 24
        0x07, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_54[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0xFF, 0xFC, 0x00,    // row 5 - 8
        0xFF, 0xFC, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,    // row 9 - 12
        0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,    // row 13 - 16
        0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,    // row 17 - 20
        0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00,    // row 21 - 24
        0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_55[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x30, 0x03, 0x00,    // row 5 - 8
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00,    // row 9 - 12
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00,    // row 13 - 16
        0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00,    // row 17 - 20
        0x30, 0x03, 0x00, 0x38, 0x07, 0x00, 0x1C, 0x0E, 0x00, 0x0F, 0xFC, 0x00,    // row 21 - 24
        0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_56[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0xE0, 0x0E, 0x00,    // row 5 - 8
        0x60, 0x0C, 0x00, 0x60, 0x0C, 0x00, 0x60, 0x0C, 0x00, 0x30, 0x18, 0x00,    // row 9 - 12
        0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x18, 0x30, 0x00, 0x18, 0x30, 0x00,    // row 13 - 16
        0x18, 0x30, 0x00, 0x0C, 0x60, 0x00, 0x0C, 0x60, 0x00, 0x0C, 0x60, 0x00,    // row 17 - 20
        0x06, 0xC0, 0x00, 0x06, 0xC0, 0x00, 0x07, 0xC0, 0x00, 0x03, 0x80, 0x00,    // row 21 - 24
        0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_57[] =        // 4 bytes per row
{
           // row 1 - 3
           // row 4 - 6
        0x00, 0x00, 0x00, 0x00, 0xE0, 0x38, 0x0E, 0x00, 0x60, 0x38, 0x0C, 0x00,    // row 7 - 9
        0x60, 0x38, 0x0C, 0x00, 0x70, 0x6C, 0x1C, 0x00, 0x30, 0x6C, 0x18, 0x00,    // row 10 - 12
        0x30, 0x6C, 0x18, 0x00, 0x30, 0x6C, 0x18, 0x00, 0x38, 0xC6, 0x38, 0x00,    // row 13 - 15
        0x18, 0xC6, 0x30, 0x00, 0x18, 0xC6, 0x30, 0x00, 0x18, 0xC6, 0x30, 0x00,    // row 16 - 18
        0x1D, 0x83, 0x70, 0x00, 0x0D, 0x83, 0x60, 0x00, 0x0D, 0x83, 0x60, 0x00,    // row 19 - 21
        0x0D, 0x83, 0x60, 0x00, 0x0F, 0x01, 0xE0, 0x00, 0x07, 0x01, 0xC0, 0x00,    // row 22 - 24
        0x07, 0x01, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 27
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 28 - 30
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00                             // row 31 - 32
};
PROGMEM const unsigned char chr_f32_58[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x60, 0x0C, 0x00,    // row 5 - 8
        0x70, 0x1C, 0x00, 0x30, 0x18, 0x00, 0x18, 0x30, 0x00, 0x1C, 0x70, 0x00,    // row 9 - 12
        0x0C, 0x60, 0x00, 0x06, 0xC0, 0x00, 0x07, 0xC0, 0x00, 0x03, 0x80, 0x00,    // row 13 - 16
        0x03, 0x80, 0x00, 0x06, 0xC0, 0x00, 0x0E, 0xE0, 0x00, 0x0C, 0x60, 0x00,    // row 17 - 20
        0x18, 0x30, 0x00, 0x38, 0x38, 0x00, 0x30, 0x18, 0x00, 0x70, 0x1C, 0x00,    // row 21 - 24
        0xE0, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_59[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0xE0, 0x07, 0x00,    // row 5 - 8
        0x70, 0x0E, 0x00, 0x30, 0x0C, 0x00, 0x38, 0x1C, 0x00, 0x18, 0x18, 0x00,    // row 9 - 12
        0x0C, 0x30, 0x00, 0x0E, 0x70, 0x00, 0x06, 0x60, 0x00, 0x03, 0xC0, 0x00,    // row 13 - 16
        0x03, 0xC0, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00,    // row 17 - 20
        0x01, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 0x00,    // row 21 - 24
        0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_5A[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x3F, 0xFE, 0x00,    // row 5 - 8
        0x3F, 0xFE, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x38, 0x00,    // row 9 - 12
        0x00, 0x30, 0x00, 0x00, 0x60, 0x00, 0x00, 0xE0, 0x00, 0x01, 0xC0, 0x00,    // row 13 - 16
        0x03, 0x80, 0x00, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0E, 0x00, 0x00,    // row 17 - 20
        0x1C, 0x00, 0x00, 0x38, 0x00, 0x00, 0x70, 0x00, 0x00, 0x7F, 0xFE, 0x00,    // row 21 - 24
        0x7F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_5B[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 7 - 12
        0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 13 - 18
        0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00,    // row 19 - 24
        0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x1F, 0x00, 0x1F, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_5C[] =         // 2 bytes per row
{
           // row 1 - 6
        0x20, 0x00, 0x20, 0x00, 0x30, 0x00, 0x10, 0x00, 0x10, 0x00, 0x18, 0x00,    // row 7 - 12
        0x08, 0x00, 0x08, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x04, 0x00, 0x06, 0x00,    // row 13 - 18
        0x02, 0x00, 0x02, 0x00, 0x03, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x80,    // row 19 - 24
        0x00, 0x80, 0x00, 0x80, 0x00, 0xC0, 0x00, 0x40, 0x00, 0x40, 0x00, 0x60,    // row 25 - 30
        0x00, 0x20, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_5D[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00,    // row 7 - 12
        0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00,    // row 13 - 18
        0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00,    // row 19 - 24
        0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x7C, 0x00, 0x7C, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_5E[] =        // 2 bytes per row
{
           // row 1 - 3
           // row 4 - 6        I                       I
        0x00, 0x00, 0x07, 0x00, 0x0D, 0x80,    // row 7 - 9
        0x18, 0xC0, 0x30, 0x60, 0x60, 0x30,    // row 10 - 12
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 13 - 15
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 16 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 21
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 22 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 27
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 28 - 30
        0x00, 0x00, 0x00, 0x00                             // row 31 - 32
};
PROGMEM const unsigned char chr_f32_5F[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 13 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_60[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x1E, 0x00,    // row 7 - 12
        0x3F, 0x00, 0x73, 0x80, 0x61, 0x80, 0x61, 0x80, 0x73, 0x80, 0x3F, 0x00,    // row 13 - 18
        0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00	   // row 31 - 32
};
PROGMEM const unsigned char chr_f32_61[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 9 - 12
        0x0F, 0xC0, 0x00, 0x3F, 0xE0, 0x00, 0x30, 0x70, 0x00, 0x30, 0x30, 0x00,    // row 13 - 16
        0x00, 0x30, 0x00, 0x0F, 0xF0, 0x00, 0x3F, 0xF0, 0x00, 0x70, 0x30, 0x00,    // row 17 - 20
        0x60, 0x30, 0x00, 0x60, 0x30, 0x00, 0x70, 0xF0, 0x00, 0x3F, 0xBC, 0x00,    // row 21 - 24
        0x1F, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_62[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 5 - 8
        0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 9 - 12
        0x33, 0xC0, 0x00, 0x37, 0xF0, 0x00, 0x3E, 0x78, 0x00, 0x38, 0x18, 0x00,    // row 13 - 16
        0x30, 0x1C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00,    // row 17 - 20
        0x30, 0x1C, 0x00, 0x38, 0x18, 0x00, 0x3E, 0x78, 0x00, 0x37, 0xF0, 0x00,    // row 21 - 24
        0x33, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_63[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x07, 0x80, 0x1F, 0xE0, 0x3C, 0xE0, 0x30, 0x30, 0x70, 0x00, 0x60, 0x00,    // row 13 - 18
        0x60, 0x00, 0x60, 0x00, 0x70, 0x30, 0x30, 0x30, 0x3C, 0xE0, 0x1F, 0xE0,    // row 19 - 24
        0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_64[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x18, 0x00,    // row 5 - 8
        0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00,    // row 9 - 12
        0x07, 0x98, 0x00, 0x1F, 0xD8, 0x00, 0x3C, 0xF8, 0x00, 0x30, 0x38, 0x00,    // row 13 - 16
        0x70, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00,    // row 17 - 20
        0x70, 0x18, 0x00, 0x30, 0x38, 0x00, 0x3C, 0xF8, 0x00, 0x1F, 0xD8, 0x00,    // row 21 - 24
        0x07, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_65[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 9 - 12
        0x07, 0x80, 0x00, 0x1F, 0xE0, 0x00, 0x3C, 0xF0, 0x00, 0x30, 0x30, 0x00,    // row 13 - 16
        0x70, 0x18, 0x00, 0x7F, 0xF8, 0x00, 0x7F, 0xF8, 0x00, 0x60, 0x00, 0x00,    // row 17 - 20
        0x70, 0x00, 0x00, 0x30, 0x38, 0x00, 0x3C, 0xF0, 0x00, 0x1F, 0xE0, 0x00,    // row 21 - 24
        0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_66[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x1E, 0x00, 0x3E, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 7 - 12
        0xFE, 0x00, 0xFE, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 13 - 18
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 19 - 24
        0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_67[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 9 - 12
        0x07, 0x98, 0x00, 0x1F, 0xD8, 0x00, 0x3C, 0xF8, 0x00, 0x30, 0x38, 0x00,    // row 13 - 16
        0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00,    // row 17 - 20
        0x70, 0x18, 0x00, 0x30, 0x38, 0x00, 0x3C, 0xF8, 0x00, 0x1F, 0xD8, 0x00,    // row 21 - 24
        0x07, 0x98, 0x00, 0x00, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x38, 0x00,    // row 25 - 28
        0x38, 0x70, 0x00, 0x3F, 0xF0, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_68[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 5 - 8
        0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 9 - 12
        0x33, 0xE0, 0x00, 0x37, 0xF0, 0x00, 0x3C, 0x38, 0x00, 0x38, 0x18, 0x00,    // row 13 - 16
        0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00,    // row 17 - 20
        0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00,    // row 21 - 24
        0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_69[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 13 - 18
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 19 - 24
        0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_6A[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 13 - 18
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 19 - 24
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0xF0, 0x00,    // row 25 - 30
        0xE0, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_6B[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 7 - 12
        0x30, 0x70, 0x30, 0xE0, 0x31, 0xC0, 0x33, 0x80, 0x37, 0x00, 0x3F, 0x00,    // row 13 - 18
        0x3F, 0x80, 0x39, 0x80, 0x31, 0xC0, 0x30, 0xC0, 0x30, 0xE0, 0x30, 0x60,    // row 19 - 24
        0x30, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_6C[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 7 - 12
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 13 - 18
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 19 - 24
        0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_6D[] =        // 4 bytes per row
{
           // row 1 - 3
           // row 4 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 9
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 10 - 12
        0x33, 0xC3, 0xC0, 0x00, 0x37, 0xEF, 0xE0, 0x00, 0x3C, 0x7C, 0x70, 0x00,    // row 13 - 15
        0x38, 0x38, 0x30, 0x00, 0x30, 0x30, 0x30, 0x00, 0x30, 0x30, 0x30, 0x00,    // row 16 - 18
        0x30, 0x30, 0x30, 0x00, 0x30, 0x30, 0x30, 0x00, 0x30, 0x30, 0x30, 0x00,    // row 19 - 21
        0x30, 0x30, 0x30, 0x00, 0x30, 0x30, 0x30, 0x00, 0x30, 0x30, 0x30, 0x00,    // row 22 - 24
        0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 27
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 28 - 30
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00                             // row 31 - 32
};
PROGMEM const unsigned char chr_f32_6E[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 9 - 12
        0x33, 0xE0, 0x00, 0x37, 0xF0, 0x00, 0x3C, 0x38, 0x00, 0x38, 0x18, 0x00,    // row 13 - 16
        0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00,    // row 17 - 20
        0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00,    // row 21 - 24
        0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_6F[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 9 - 12
        0x07, 0xC0, 0x00, 0x1F, 0xF0, 0x00, 0x3C, 0x78, 0x00, 0x30, 0x18, 0x00,    // row 13 - 16
        0x70, 0x1C, 0x00, 0x60, 0x0C, 0x00, 0x60, 0x0C, 0x00, 0x60, 0x0C, 0x00,    // row 17 - 20
        0x70, 0x1C, 0x00, 0x30, 0x18, 0x00, 0x3C, 0x78, 0x00, 0x1F, 0xF0, 0x00,    // row 21 - 24
        0x07, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_70[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 9 - 12
        0x33, 0xC0, 0x00, 0x37, 0xF0, 0x00, 0x3E, 0x78, 0x00, 0x38, 0x18, 0x00,    // row 13 - 16
        0x30, 0x1C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00, 0x30, 0x0C, 0x00,    // row 17 - 20
        0x30, 0x1C, 0x00, 0x38, 0x18, 0x00, 0x3E, 0x78, 0x00, 0x37, 0xF0, 0x00,    // row 21 - 24
        0x33, 0xC0, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x30, 0x00, 0x00,    // row 25 - 28
        0x30, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_71[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 9 - 12
        0x07, 0x98, 0x00, 0x1F, 0xD8, 0x00, 0x3C, 0xF8, 0x00, 0x30, 0x38, 0x00,    // row 13 - 16
        0x70, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00, 0x60, 0x18, 0x00,    // row 17 - 20
        0x70, 0x18, 0x00, 0x30, 0x38, 0x00, 0x3C, 0xF8, 0x00, 0x1F, 0xD8, 0x00,    // row 21 - 24
        0x07, 0x98, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00,    // row 25 - 28
        0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_72[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x37, 0x00, 0x3F, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 13 - 18
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 19 - 24
        0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_73[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x1F, 0x00, 0x3F, 0xC0, 0x70, 0xC0, 0x60, 0x60, 0x60, 0x00, 0x3E, 0x00,    // row 13 - 18
        0x1F, 0xC0, 0x03, 0xE0, 0x00, 0x60, 0x60, 0x60, 0x70, 0xE0, 0x3F, 0xC0,    // row 19 - 24
        0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_74[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 7 - 12
        0xFC, 0x00, 0xFC, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,    // row 13 - 18
        0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x3C, 0x00,    // row 19 - 24
        0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_75[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 9 - 12
        0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00,    // row 13 - 16
        0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00, 0x30, 0x18, 0x00,    // row 17 - 20
        0x30, 0x18, 0x00, 0x30, 0x38, 0x00, 0x38, 0x78, 0x00, 0x1F, 0xD8, 0x00,    // row 21 - 24
        0x0F, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_76[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0xC0, 0x60, 0xC0, 0x60, 0x60, 0xC0, 0x60, 0xC0, 0x60, 0xC0, 0x31, 0x80,    // row 13 - 18
        0x31, 0x80, 0x31, 0x80, 0x1B, 0x00, 0x1B, 0x00, 0x1F, 0x00, 0x0E, 0x00,    // row 19 - 24
        0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_77[] =         // 3 bytes per row
{
           // row 1 - 4
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 5 - 8
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 9 - 12
        0xC1, 0xC1, 0x80, 0xC1, 0xC1, 0x80, 0xC1, 0x41, 0x80, 0x63, 0x63, 0x00,    // row 13 - 16
        0x63, 0x63, 0x00, 0x63, 0x63, 0x00, 0x62, 0x23, 0x00, 0x36, 0x36, 0x00,    // row 17 - 20
        0x36, 0x36, 0x00, 0x36, 0x36, 0x00, 0x1C, 0x1C, 0x00, 0x1C, 0x1C, 0x00,    // row 21 - 24
        0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 28
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     // row 29 - 32
};
PROGMEM const unsigned char chr_f32_78[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x60, 0x30, 0x70, 0x70, 0x30, 0x60, 0x18, 0xC0, 0x1D, 0xC0, 0x0F, 0x80,    // row 13 - 18
        0x07, 0x00, 0x0F, 0x80, 0x1D, 0xC0, 0x18, 0xC0, 0x30, 0x60, 0x70, 0x70,    // row 19 - 24
        0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_79[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0xE0, 0x38, 0x60, 0x30, 0x60, 0x30, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60,    // row 13 - 18
        0x18, 0xC0, 0x18, 0xC0, 0x18, 0xC0, 0x0D, 0x80, 0x0D, 0x80, 0x0D, 0x80,    // row 19 - 24
        0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x06, 0x00, 0x0E, 0x00, 0x7C, 0x00,    // row 25 - 30
        0x78, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_7A[] =         // 2 bytes per row
{
           // row 1 - 6
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 7 - 12
        0x7F, 0xE0, 0x7F, 0xE0, 0x00, 0xE0, 0x01, 0xC0, 0x03, 0x80, 0x07, 0x00,    // row 13 - 18
        0x06, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x38, 0x00, 0x70, 0x00, 0x7F, 0xE0,    // row 19 - 24
        0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 30
        0x00, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_7B[] =         // 2 bytes per row
{
           // row 1 - 6
        0x01, 0xE0, 0x03, 0x80, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00,    // row 7 - 12
        0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x06, 0x00,    // row 13 - 18
        0x1C, 0x00, 0x06, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00,    // row 19 - 24
        0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x80,    // row 25 - 30
        0x01, 0xE0, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_7C[] =         // 2 bytes per row
{
           // row 1 - 6
        0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00,    // row 7 - 12
        0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00,    // row 13 - 18
        0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00,    // row 19 - 24
        0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00,    // row 25 - 30
        0x06, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_7D[] =         // 2 bytes per row
{
           // row 1 - 6
        0x3C, 0x00, 0x0E, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00,    // row 7 - 12
        0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x03, 0x00,    // row 13 - 18
        0x01, 0xC0, 0x03, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00,    // row 19 - 24
        0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x0E, 0x00,    // row 25 - 30
        0x3C, 0x00, 0x00, 0x00                                                     // row 31 - 32
};
PROGMEM const unsigned char chr_f32_7E[] =        // 3 bytes per row
{
           // row 1 - 3
           // row 4 - 6
        0x00, 0x00, 0x00, 0x1E, 0x01, 0x00, 0x33, 0x01, 0x00,    // row 7 - 9
        0x61, 0xC3, 0x00, 0x40, 0x66, 0x00, 0x40, 0x3C, 0x00,    // row 10 - 12
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 13 - 15
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 16 - 18
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 19 - 21
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 22 - 24
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 25 - 27
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 28 - 30
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00                             // row 31 - 32
};
PROGMEM const unsigned char chr_f32_7F[] =         // 1 byte per row
{
        0x00, 0x00, 0x00, 0x00, 0x00,    // row 1 - 11
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // row 12 - 22
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00           // row 23 - 32
};

PROGMEM const unsigned char* const chrtbl_f32[96] =       // character pointer table
{
        chr_f32_20, chr_f32_21, chr_f32_22, chr_f32_23, chr_f32_24, chr_f32_25, chr_f32_26, chr_f32_27, 
        chr_f32_28, chr_f32_29, chr_f32_2A, chr_f32_2B, chr_f32_2C, chr_f32_2D, chr_f32_2E, chr_f32_2F, 
        chr_f32_30, chr_f32_31, chr_f32_32, chr_f32_33, chr_f32_34, chr_f32_35, chr_f32_36, chr_f32_37, 
        chr_f32_38, chr_f32_39, chr_f32_3A, chr_f32_3B, chr_f32_3C, chr_f32_3D, chr_f32_3E, chr_f32_3F, 
        chr_f32_40, chr_f32_41, chr_f32_42, chr_f32_43, chr_f32_44, chr_f32_45, chr_f32_46, chr_f32_47, 
        chr_f32_48, chr_f32_49, chr_f32_4A, chr_f32_4B, chr_f32_4C, chr_f32_4D, chr_f32_4E, chr_f32_4F, 
        chr_f32_50, chr_f32_51, chr_f32_52, chr_f32_53, chr_f32_54, chr_f32_55, chr_f32_56, chr_f32_57, 
        chr_f32_58, chr_f32_59, chr_f32_5A, chr_f32_5B, chr_f32_5C, chr_f32_5D, chr_f32_5E, chr_f32_5F, 
        chr_f32_60, chr_f32_61, chr_f32_62, chr_f32_63, chr_f32_64, chr_f32_65, chr_f32_66, chr_f32_67, 
        chr_f32_68, chr_f32_69, chr_f32_6A, chr_f32_6B, chr_f32_6C, chr_f32_6D, chr_f32_6E, chr_f32_6F, 
        chr_f32_70, chr_f32_71, chr_f32_72, chr_f32_73, chr_f32_74, chr_f32_75, chr_f32_76, chr_f32_77, 
        chr_f32_78, chr_f32_79, chr_f32_7A, chr_f32_7B, chr_f32_7C, chr_f32_7D, chr_f32_7E, chr_f32_7F
};
